<?

class Db
{

    private $connection;
    private static $db;


    public static function getInstance($option = null): Db
    {
        if (self::$db == null) {
            self::$db = new Db($option);
        }

        return self::$db;
    }


    public function __construct($option = null)
    {
        if ($option != null) {
            $host = $option['host'];
            $user = $option['user'];
            $pass = $option['pass'];
            $name = $option['name'];
        } else {
//            global $config;
            $host = 'localhost';//$config['db']['host'];
            $user="paymanbe_pbboobi";//paymanbe_pbboobi
            $pass="_%OB$-bHO!v)";// _%OB$-bHO!v)
            $name="paymanbe_boobi";//paymanbe_boobi
        }

        $this->connection = new mysqli($host, $user, $pass, $name);
        if ($this->connection->connect_error) {
            echo "Connection failed: " . $this->connection->connect_error;
            exit;
        }

        $this->connection->query("SET NAMES 'utf8'");
    }


    private function safeQuery(&$sql, $data)
    {
        foreach ($data as $key => $value) {
            $value = $this->connection->real_escape_string($value);
            if (get_magic_quotes_gpc()) {
                $value = stripslashes($value);
            }
            $value = addslashes($value);
            if (strtolower($value) == "null") {
                $value = "NULL";
            } else {
                $value = "'$value'";
            }
            $sql = str_replace(":$key", $value, $sql);
        }

        return $this->connection->query($sql);
    }


    public function first($sql, $data = array(), $field = null)
    {
        $records = $this->query($sql, $data);
        if (count($records) == 0) {
            return null;
        }

        if ($field != null) {
            return $records[0][$field];
        }

        return $records[0];
    }


    public function modify($sql, $data = array(), $check = false)
    {
        global $config;
        $result = $this->safeQuery($sql, $data);
        if (!$result && $config['test_mode']) {
            echo "Query: " . $sql . " failed due to " . mysqli_error($this->connection);
            exit;
        }
        if ($check) {
            if (mysqli_affected_rows($this->connection) > 0) {
                return true;
            } else {
                return false;
            }
        }
        return $result;
    }


    public function insert($sql, $data = array())
    {
        global $config;
        $result = $this->safeQuery($sql, $data);
        if (!$result && $config['test_mode']) {
            echo "Query: " . $sql . " failed due to " . mysqli_error($this->connection);
            exit;
        }
        return mysqli_insert_id($this->connection);
    }


    public function query($sql, $data = array())
    {
        global $config;
        $result = $this->safeQuery($sql, $data);
        if (!$result && $config['test_mode']) {
            echo "Query: " . $sql . " failed due to " . mysqli_error($this->connection);
            exit;
        }

        $records = array();

        if ($result->num_rows == 0) {
            return $records;
        }

        while ($row = $result->fetch_assoc()) {
            $records[] = $row;
        }

        return $records;
    }


    public function connection(): mysqli
    {
        return $this->connection;
    }


    public function close()
    {
        $this->connection->close();
    }

}